require( "quest/subwaymap/convout.lua" );
combine_speech_tables();

local curmodule;

layout =
{
	ave_flo_station = { x = 147, y = 70 },
	sizzle_st_station = { x = 382, y = 70 },
	pancake_rd_station = { x = 613, y = 70 },
}

locationInfo = 
{
	module1 = { x = 150, y = 179 };
	module2 = { x = 387, y = 179 };
	module3 = { x = 618, y = 179 };
}

direction_text_spec =
{
	color = { a = 1, r = 1, g = 0, b = 0 };
	w = 200,
	h = 100,
	bubble = false,
	outline_size = 0,
	lineheight = 25,
	anchor = ANCHOR.TOP,
	halign = HALIGN.LEFT,
};

station_text_width = 150;
station_text_offset_x = 25;
station_text_offset_y = 10;
station_text_spec =
{
	color = { a = 1, r = 0, g = 0, b = 0 };
	w = station_text_width,
	h = 100,
	bubble = false,
	outline_size = 0,
	lineheight = 25,
	anchor = ANCHOR.TOP,
	halign = HALIGN.LEFT,
};

location_text_width = 230;
location_text_offset_x = 70;
location_text_offset_y = 187;
location_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 };
	w = location_text_width,
	h = 100,
	bubble = false,
	outline_size = 0,
	lineheight = 17,
	anchor = ANCHOR.TOP,
	halign = HALIGN.LEFT,
};

flo_spec =
{
	name = "FLO";
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

eastbound_spec =
{
	name = "EASTBOUND";
	gfx = { image = "eastbound" };
	
	command = function(actor)
		actor:ModifySaySpec(direction_text_spec);
		actor:ModifySaySpec
		{
			x = 507,
			y = 375,
		};
		
		actor:Say("text_eastbound");
	end;
}

westbound_spec =
{
	name = "WESTBOUND";
	gfx = { image = "westbound" };
	
	command = function(actor)
		actor:ModifySaySpec(direction_text_spec);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 1 },
			x = 197,
			y = 429,
		};
		
		actor:Say("text_westbound");
	end;
}

choose_station_text_spec = 
{
	name = "CHOOSE_STATION_TEXT";
	
	command = function(actor)
		actor:ModifySaySpec(direction_text_spec);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			x = 200,
			y = 400,
			w = 600,
		};
		
		actor:Say("text_choose_station");
	end;
}

map_spec = 
{
	name = "MAP";
	halo = "map";
	
	command = function(actor)
		actor:SetPointAtCursor("cursor");
		actor:SetDepthValue(100);
	end;
}

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		game:Set("last_module", game:Get("cur_module"));
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_HANDLED;
	end;
}

aveflo_spec = 
{
	name = "AVEFLO";
	gfx = { image = "station1_highlight" };
	
	command = function(actor)
		if game:Get("subway_eastbound") == 0 and curmodule ~= 1 then
			actor:LoadZone("aveflo");
		end
		
		actor:ModifySaySpec(station_text_spec);
		actor:ModifySaySpec
		{
			y = layout.ave_flo_station.y + station_text_offset_y,
			x = layout.ave_flo_station.x - (station_text_width * 0.5) + station_text_offset_x,
		};
		
		actor:Say("text_ave_flo_station");
		
		scene:Spawn(ave_flo_locations_spec);
		
		actor:SetDepthValue(200);
		actor:SetAlpha(0);
	end;
	
	on_arrive = function(flo, actor)
		game:Set("last_module", game:Get("cur_module"));
		game:Set("cur_module", 1)
		scene:ReturnFromScene();
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor:SetAlpha(1);
		else
			actor:SetAlpha(0);
		end
	end;
}

sizzlest_spec = 
{
	name = "SIZZLEST";
	gfx = { image = "station2_highlight" };
	
	command = function(actor)
		if game:Get("subway_eastbound") <= 1 and curmodule ~= 2 then
			actor:LoadZone("sizzlest");
		end
		
		actor:ModifySaySpec(station_text_spec);
		actor:ModifySaySpec
		{
			y = layout.sizzle_st_station.y + station_text_offset_y,
			x = layout.sizzle_st_station.x - (station_text_width * 0.5) + station_text_offset_x,
		};
		
		actor:Say("text_sizzle_st_station");
		
		scene:Spawn(sizzle_st_locations_spec);
		
		actor:SetDepthValue(200);
		actor:SetAlpha(0);
	end;
	
	on_arrive = function(flo, actor)
		game:Set("last_module", game:Get("cur_module"));
		game:Set("cur_module", 2)
		scene:ReturnFromScene();
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor:SetAlpha(1);
		else
			actor:SetAlpha(0);
		end
	end;
}

pancakerd_spec = 
{
	name = "PANCAKERD";
	gfx = { image = "station3_highlight" };
	
	command = function(actor)
		if game:Get("subway_eastbound") == 1 and curmodule ~= 3 and game:Get("module_progress") > 1 then
			actor:LoadZone("pancakerd");
		end
		
		actor:ModifySaySpec(station_text_spec);
		actor:ModifySaySpec
		{
			y = layout.pancake_rd_station.y + station_text_offset_y,
			x = layout.pancake_rd_station.x - (station_text_width * 0.5) + station_text_offset_x,
		};
		
		actor:Say("text_pancake_rd_station");
		
		scene:Spawn(pancake_rd_locations_spec);
		
		actor:SetDepthValue(200);
		actor:SetAlpha(0);
	end;
	
	on_arrive = function(flo, actor)
		game:Set("last_module", game:Get("cur_module"));
		game:Set("cur_module", 3)
		scene:ReturnFromScene();
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor:SetAlpha(1);
		else
			actor:SetAlpha(0);
		end
	end;
}

ave_flo_locations_spec =
{
	name = "AVE_FLO_LOCATIONS";
	
	command = function(actor)
		actor:ModifySaySpec(location_text_spec);
		actor:ModifySaySpec
		{
			y = layout.ave_flo_station.y + location_text_offset_y,
			x = layout.ave_flo_station.x - (location_text_width * 0.5) + location_text_offset_x,
		};
		
		actor:Say("text_ave_flo_locations");
	end;
}

sizzle_st_locations_spec =
{
	name = "SIZZLE_ST_LOCATIONS";
	
	command = function(actor)
		actor:ModifySaySpec(location_text_spec);
		actor:ModifySaySpec
		{
			y = layout.sizzle_st_station.y + location_text_offset_y,
			x = layout.sizzle_st_station.x - (location_text_width * 0.5)  + location_text_offset_x,
		};
		
		actor:Say("text_sizzle_st_locations");
	end;
}

pancake_rd_locations_spec =
{
	name = "PANCAKE_RD_LOCATIONS";
	
	command = function(actor)
		actor:ModifySaySpec(location_text_spec);
		actor:ModifySaySpec
		{
			y = layout.pancake_rd_station.y + location_text_offset_y,
			x = layout.pancake_rd_station.x - (location_text_width * 0.5) + location_text_offset_x,
		};
		
		actor:Say("text_pancake_rd_locations");
	end;
}

you_are_here_spec = 
{
	name = "YOU_ARE_HERE";
	
	command = function(actor)
		local text_pos = { x = 0, y = 0 };
		local text_width = 150;
		
		local pos;
		local offset = { x = 10, y = -5 };
		if curmodule == 1 then
			text_pos = locationInfo.module1;
		elseif curmodule == 2 then
			text_pos = locationInfo.module2;
		else
			text_pos = locationInfo.module3;
		end
		text_pos = { x = text_pos.x + offset.x, y = text_pos.y + offset.y };
		
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0.75, b = 0 },
			x = text_pos.x - (text_width * 0.5),
			y = text_pos.y - 30,
			w = text_width,
			h = 100,
			bubble = false,
			outline_size = 0,
			lineheight = 16,
			anchor = ANCHOR.TOP,
			halign = HALIGN.CENTER,
		};
		
		actor:Say("text_you_are_here");
	end;
}

location_spec = 
{
	name = "LOCATION";
	gfx = { image = "youarehere" };
	
	command = function(actor)
		local pos;
		if curmodule == 1 then	
			pos = locationInfo.module1;
		elseif curmodule == 2 then
			pos = locationInfo.module2;
		else
			pos = locationInfo.module3;
		end
		actor:JumpToPoint( pos );
	end;
}

highlight_spec = 
{
	name = "HIGHLIGHT";
	gfx = { image = "highlight" };
	
	command = function(actor)
		local pos;
		local offset = { x = -50, y = -40 };
		if curmodule == 1 then
			pos = locationInfo.module1;
		elseif curmodule == 2 then
			pos = locationInfo.module2;
		else
			pos = locationInfo.module3;
		end
		pos = { x = pos.x + offset.x, y = pos.y + offset.y };
		actor:JumpToPoint( pos );
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		--sfx:SetMusic("audio/music/office.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true,true);
		
		if IsCheatMode() then
			-- testing data
			--game:Set("subway_eastbound", 0);
		end
		
		curmodule = game:Get("cur_module");
		scene:Spawn(aveflo_spec);
		scene:Spawn(sizzlest_spec);
		scene:Spawn(pancakerd_spec);
		scene:Spawn(you_are_here_spec);
		scene:Spawn(location_spec);
		scene:Spawn(highlight_spec);
		
		if game:Get("subway_eastbound") < 2 then
			scene:Spawn(choose_station_text_spec);
		else -- just look at map in subway
			if curmodule <= 1 then
				scene:Spawn(eastbound_spec);
			elseif curmodule == 2 then
				scene:Spawn(eastbound_spec);
				scene:Spawn(westbound_spec);
			else
				scene:Spawn(westbound_spec);
			end
		end
	end;
};


scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		map_spec,
		back_spec,
		--sizzlest_spec,
		
		scene_setup,
	};
};
